/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import net.ftb.events.PackChangeEvent;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.FTBPacksPane;
import net.ftb.gui.panes.ThirdPartyPane;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;
import net.ftb.util.OSUtils;
import net.ftb.workers.ModpackLoader;

public class ModPack {
    private String name;
    private String author;
    private String version;
    private String url;
    private String dir;
    private String mcVersion;
    private String serverUrl;
    private String logoName;
    private String imageName;
    private String info;
    private String animation;
    private String maxPermSize;
    private String sep = File.separator;
    private String xml;
    private String[] mods;
    private String[] oldVersions;
    private Image logo;
    private Image image;
    private int index;
    private boolean updated = false;
    private boolean hasCustomTP;
    private boolean hasbundledmap;
    private boolean thirdPartyTab;
    private static final ArrayList<ModPack> packs = Lists.newArrayList();
    private boolean privatePack;
    private int[] minJRE;
    private int minLaunchSpec;
    private String disclaimer;
    private HashMap<String, String> customMCVersions = Maps.newHashMap();

    public static void loadXml(ArrayList<String> xmlFile) {
        ModpackLoader loader = new ModpackLoader(xmlFile);
        loader.start();
    }

    public static void loadXml(String xmlFile) {
        ArrayList<String> temp = Lists.newArrayList();
        temp.add(xmlFile);
        ModpackLoader loader = new ModpackLoader(temp);
        loader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPack(ModPack pack) {
        ArrayList<ModPack> arrayList = packs;
        synchronized (arrayList) {
            packs.add(pack);
            LaunchFrame.getInstance().getEventBus().post(new PackChangeEvent(PackChangeEvent.TYPE.ADD, new ArrayList<ModPack>().add(pack), new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPacks(ArrayList<ModPack> packs_) {
        ArrayList<ModPack> arrayList = packs;
        synchronized (arrayList) {
            for (ModPack p : packs_) {
                packs.add(p);
            }
            LaunchFrame.getInstance().getEventBus().post(new PackChangeEvent(PackChangeEvent.TYPE.ADD, packs_));
        }
    }

    public static void removePacks(String xml) {
        ArrayList<ModPack> remove = Lists.newArrayList();
        int removed = -1;
        for (ModPack pack : packs) {
            if (!pack.getParentXml().equalsIgnoreCase(xml)) continue;
            remove.add(pack);
        }
        for (ModPack pack : remove) {
            removed = pack.getIndex();
            packs.remove(pack);
        }
        for (ModPack pack : packs) {
            if (removed == -1 || pack.getIndex() <= removed) continue;
            pack.setIndex(pack.getIndex() - 1);
        }
        LaunchFrame.getInstance().getEventBus().post(new PackChangeEvent(PackChangeEvent.TYPE.REMOVE, true, xml));
    }

    public static ArrayList<ModPack> getPackArray() {
        return packs;
    }

    public static ModPack getPack(int i) {
        return packs.get(i);
    }

    public static ModPack getPack(String dir) {
        for (ModPack pack : packs) {
            if (!pack.getDir().equalsIgnoreCase(dir)) continue;
            return pack;
        }
        return null;
    }

    public static ModPack getSelectedPack() {
        if (LaunchFrame.currentPane == LaunchFrame.Panes.THIRDPARTY) {
            return ModPack.getPack(ThirdPartyPane.getInstance().getSelectedThirdPartyModIndex());
        }
        return ModPack.getPack(FTBPacksPane.getInstance().getSelectedFTBModIndex());
    }

    public static ModPack getSelectedPack(boolean isFTBPane) {
        return isFTBPane ? ModPack.getPack(FTBPacksPane.getInstance().getSelectedFTBModIndex()) : ModPack.getPack(ThirdPartyPane.getInstance().getSelectedThirdPartyModIndex());
    }

    public ModPack(String name, String author, String version, String logo, String url, String image, String dir, String mcVersion, String serverUrl, String info, String mods, String oldVersions, String animation, String maxPermSize, int idx, boolean privatePack, String xml, boolean bundledMap, boolean customTP, String minJRE, boolean thirdpartyTab, int minLaunchSpec, String disclaimer, String customMCVersions) throws IOException, NoSuchAlgorithmException {
        this.index = idx;
        this.name = name;
        this.author = author;
        this.version = version;
        this.dir = dir;
        this.mcVersion = mcVersion;
        this.url = url;
        this.serverUrl = serverUrl;
        this.privatePack = privatePack;
        this.xml = xml;
        this.maxPermSize = maxPermSize;
        this.hasbundledmap = bundledMap;
        this.hasCustomTP = customTP;
        this.minLaunchSpec = minLaunchSpec;
        String[] tempJRE = minJRE.split("\\.");
        ArrayList<Integer> tmpIJre = Lists.newArrayList();
        for (String aTempJRE : tempJRE) {
            tmpIJre.add(Integer.parseInt(aTempJRE));
        }
        this.minJRE = Ints.toArray(tmpIJre);
        this.animation = !animation.isEmpty() ? animation : "empty";
        this.logoName = logo;
        this.imageName = image;
        this.info = info;
        this.disclaimer = disclaimer;
        this.mods = mods.isEmpty() ? null : mods.split("; ");
        this.oldVersions = oldVersions == null || oldVersions.isEmpty() ? null : oldVersions.split(";");
        if (customMCVersions != null && !customMCVersions.isEmpty()) {
            String[] tmp = customMCVersions.split(";");
            if (tmp == null) {
                tmp = new String[]{customMCVersions};
            }
            for (String s : tmp) {
                String[] s2 = s.split("\\^");
                this.customMCVersions.put(s2[0], s2[1]);
            }
        }
        String installPath = OSUtils.getCacheStorageLocation();
        File tempDir = new File(installPath, "ModPacks" + this.sep + dir);
        File verFile = new File(tempDir, "version");
        this.thirdPartyTab = thirdpartyTab;
        if (!this.upToDate(verFile)) {
            DownloadUtils.saveImage(logo, tempDir, "png");
            DownloadUtils.saveImage(image, tempDir, "png");
        } else {
            if (!new File(tempDir, logo).exists()) {
                DownloadUtils.saveImage(logo, tempDir, "png");
            }
            if (!new File(tempDir, image).exists()) {
                DownloadUtils.saveImage(image, tempDir, "png");
            }
        }
        if (!new File(tempDir, logo).exists()) {
            logo = "logo_ftb.png";
            this.logoName = "logo_ftb.png";
            DownloadUtils.saveImage(logo, tempDir, "png");
        }
        this.logo = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + logo);
        if (!new File(tempDir, image).exists()) {
            image = "default_splash.png";
            this.imageName = "default_splash.png";
            DownloadUtils.saveImage(image, tempDir, "png");
        }
        this.image = Toolkit.getDefaultToolkit().createImage(tempDir.getPath() + this.sep + image);
    }

    private boolean upToDate(File verFile) {
        String storedVersion = this.getStoredVersion(verFile).replace(".", "");
        int storedVersion_ = -1;
        if (!storedVersion.isEmpty()) {
            try {
                storedVersion_ = Integer.parseInt(storedVersion);
            }
            catch (NumberFormatException e) {
                Logger.logWarn("Automatically fixing malformed version file for " + this.name, e);
                storedVersion = "";
            }
        }
        if (storedVersion.isEmpty() || storedVersion_ != Integer.parseInt(this.version.replace(".", ""))) {
            try {
                if (!verFile.exists()) {
                    verFile.getParentFile().mkdirs();
                    verFile.createNewFile();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(verFile));
                out.write(this.version);
                out.flush();
                out.close();
                return false;
            }
            catch (IOException e) {
                Logger.logError("Error while checking modpack version", e);
                return false;
            }
        }
        return true;
    }

    public boolean needsUpdate(File verFile) {
        return Integer.parseInt(this.getStoredVersion(verFile).replace(".", "")) != Integer.parseInt(this.version.replace(".", ""));
    }

    public String getStoredVersion(File verFile) {
        String result = "";
        try {
            BufferedReader in;
            String line;
            if (!verFile.exists()) {
                verFile.getParentFile().mkdirs();
                verFile.createNewFile();
            }
            if ((line = (in = new BufferedReader(new FileReader(verFile))).readLine()) != null) {
                result = line;
            }
            in.close();
        }
        catch (IOException e) {
            Logger.logError("Error while getting modpack version", e);
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public Image getLogo() {
        return this.logo;
    }

    public String getUrl() {
        return this.url;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDir() {
        return this.dir;
    }

    public String getMcVersion() {
        return this.mcVersion;
    }

    public String getMcVersion(String packVersion) {
        if (this.customMCVersions != null && this.customMCVersions.containsKey(packVersion)) {
            return this.customMCVersions.get(packVersion);
        }
        return this.mcVersion;
    }

    public String getInfo() {
        return this.info;
    }

    public String[] getMods() {
        return this.mods;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getLogoName() {
        return this.logoName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setUpdated(boolean result) {
        this.updated = result;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public String[] getOldVersions() {
        return this.oldVersions;
    }

    public void setMcVersion(String version) {
        this.mcVersion = version;
    }

    public String getAnimation() {
        return this.animation;
    }

    public boolean isPrivatePack() {
        return this.privatePack;
    }

    public String getParentXml() {
        return this.xml;
    }

    public String getMaxPermSize() {
        return this.maxPermSize;
    }

    public boolean getBundledMap() {
        return this.hasbundledmap;
    }

    public boolean hasCustomTP() {
        return this.hasCustomTP;
    }

    public static void setVanillaPackMCVersion(String string) {
        for (int i = 0; i < packs.size(); ++i) {
            if (!packs.get(i).getDir().equals("mojang_vanilla")) continue;
            ModPack temp = packs.get(i);
            temp.setMcVersion(string);
            packs.remove(i);
            packs.add(i, temp);
            return;
        }
    }

    public boolean isThirdPartyTab() {
        return this.thirdPartyTab;
    }

    public int[] getMinJRE() {
        return this.minJRE;
    }

    public int getMinLaunchSpec() {
        return this.minLaunchSpec;
    }

    public String getDisclaimer() {
        return this.disclaimer;
    }

    public HashMap<String, String> getCustomMCVersions() {
        return this.customMCVersions;
    }
}

